package javasposhhunter;

import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.AgentMemory;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;

import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Here is the place to implement your acts and senses
 * The log domain of a behaviour is set to class name.
 *
 * act:
 *     in plan file: shoot
 *     in behaviour: public void action_shoot()
 * sense:
 *     in plan file: hear
 *     in behaviour: public boolean sense_hear()
 *
 * E.g. see action_doNothing() /  sense_fail()
 */
public class MyBehaviour extends JavaBehaviour {
    /** choosen item for the state seeItem */
    protected Item choosenItem = null;
    /** 
      * Stores last unreachable item - item that bot chose and was not able to go to. <br>
      * This setting should prevent bot from stucks.
      */
    protected Item previousChoosenItem = null;
    /** is used to store shuffled list of weapons bot runs around */
    public ArrayList<Item> itemsToRunAround = new ArrayList<Item>();
    /** choose med kits for the stateMedKit */
    protected ArrayList <Item> choosenMedKits = null;
    /** last enemy which disappeared from agent's view */
    private Player lastEnemy = null;
    /** the enemy we're fixed at. If null no enemy is engaged. */
    private Player enemy = null;        
    /** max attempts in reaching the item */
    protected final int MAX_ATTEMPTS = 10;
    /** counter for attempts in reaching the item */ 
    protected int walkingAttempts = 0;
    /** walking mystic properties - prevent bot from continuous jumping - he will jump only once */
    private boolean jumped;
    /** use built-in A* algorithm or not use built-in A* algorithm? that is a question */
    public boolean useAStar = false;
    /** how low the health level should be to start collecting healht */
    public int healthLevel = 90;
    
    public boolean first_run=true;
    
    public MyBehaviour(String name, Logger log, SPoshBot bot) {
        super(name, log, bot);
    }
    
    /**
      * call predefined function in GameMap - runAroundWeaponsInTheMap
     */
    public void action_runAroundItems(){
        
        this.log.info("Action RUN_AROUND_ITEMS.");
        if(first_run){
            first_run=false;
            this.itemsToRunAround = new ArrayList<Item>();
        }
        if(walkingAttempts==0){
            this.log.info("Action CREATE_ITEM_LIST.");
            if(first_run){
                first_run=false;
                this.itemsToRunAround = new ArrayList<Item>();
            }
            itemsToRunAround.clear();
             for ( Item item :  bot.getMemory().getKnownWeapons())
                    this.itemsToRunAround.add(item);
             for ( Item item : bot.getMemory().getKnownArmors())
                    this.itemsToRunAround.add(item);
            Collections.shuffle(this.itemsToRunAround);
        }
        this.walkingAttempts++;
        if(this.walkingAttempts>MAX_ATTEMPTS){
            walkingAttempts=0;            
        }
    	this.bot.getMap().runAroundItemsInTheMap(this.itemsToRunAround, useAStar);
    }
    public void action_changeToBetterWeapon(){
        AgentMemory memory=bot.getMemory();
        this.log.log(Level.INFO, "Action CHANGE WEAPON");
        if (memory.getAgentLocation() == null || memory.getSeeEnemy() == null || memory.getSeeEnemy().location == null)
            return;
        AddWeapon weapon = memory.getBetterWeapon(memory.getAgentLocation(), memory.getSeeEnemy().location);
        if (weapon != null)
            bot.getBody().changeWeapon(weapon);
    }
    /**
     * Fired when bot see any enemy.
     * <ol>
     * <li> if not shooting at enemyID - start shooting
     * <li> if out of ammo - switch to another weapon
     * <li> if enemy is reachable - run to him
     * <li> if enemy is not reachable - stand still (kind a silly, right? :-)
     * </ol>
     */
    public void action_engageEnemy(){
        AgentMemory memory=bot.getMemory();
        AgentBody body=bot.getBody();
        this.log.log(Level.INFO, "Action ENGAGE");


        AddWeapon weapon = null;
        // 1) if out of ammo - switch to another weapon
        if ((!memory.hasLoadedWeapon()) && memory.hasAnyLoadedWeapon()) {
            weapon = memory.getAnyWeapon();
            if ((weapon != null) && ((memory.getCurrentWeapon() == null) || ((memory.getCurrentWeapon() != null) 
                && (!weapon.weaponType.equals(memory.getCurrentWeapon().weaponType))))) {
                body.changeWeapon(weapon);
            } else {

            }
        }

        // 2) if not shooting at enemyID - start shooting
        double distance = (Triple.distanceInSpace(memory.getAgentLocation(), this.enemy.location));
        if (memory.getCurrentWeapon() != null && memory.getCurrentWeapon().maxDist > distance) {// it is worth shooting
            if (!memory.isShooting())
                body.shoot(this.enemy);
            else // to turn to enemy - shoot will not turn to enemy during shooting
                body.turnToTarget(this.enemy);
        }

        // 3) if enemy is far - run to him
        int decentDistance = (int) (Math.round(Math.random() * 800) + 200);
        

        if (memory.getAgentLocation() != null && this.enemy != null && this.enemy.location != null &&
                Triple.distanceInSpace(memory.getAgentLocation(), this.enemy.location) < decentDistance){
                if (memory.isMoving()){
                        body.stop();
                }
        } else {
                body.runToTarget(enemy);
                this.jumped = false;
        }
    }
    public void action_lostEnemy(){
        enemy=null;
    }
    /**
     * Fired when bot loose enemy from his view <br>
     * He just stops shooting and no more wastes his ammo
     */
    public void action_stopShooting(){
        this.log.log(Level.INFO, "Action STOP_SHOOTING");
        bot.getBody().stopShoot();
    }
    /**
     * Fired when bot is damaged, it has those options:
     * <ol>
     * <li> He has idea where to turn to from to DAM message
     * <li> He got no idea at all -> turns around
     * </ol>
     */
    public void action_hit(){
        this.log.log(Level.INFO, "Action HIT");
	bot.getBody().turnHorizontal(55);
    }
    /**
     * State pursue is for pursuing enemy who was for example lost behind a corner.
     * How it works?:
     * <ol>
     * <li> initialize properties 
     * <li> obtain path to the enemy
     * <li> follow the path - if it reaches the end - set lastEnemy to null - bot would have seen him before or lost him once for all
     * </ol>
     */
    public void action_goAtLastEnemyPosition(){
        this.log.log(Level.INFO, "Action PURSUE");
        if(!bot.getMap().safeRunToLocation(lastEnemy.location)) {         // unable to reach the choosen item
                log.info("Ended at the enemy possition or failed - > STOP THE CHASE.");
                previousChoosenItem = choosenItem;
                lastEnemy = null;
        }
        return;
    }
    /**
     * Fired when bot is moving, checks few accidents than can happen to him
     * <ol>
     * <li> Wall collision
     * <li> Bump to another actor of the game
     * </ol>
     */
    public void action_walking(){
        this.log.log(Level.INFO, "Action WALKING");
        AgentMemory memory=bot.getMemory();
        AgentBody body=bot.getBody();
        if (memory.isColliding())
            if (!this.jumped){
                body.doubleJump();
                this.jumped = true;
            } else {
                body.stop();
                this.jumped = false;
            }
        if (memory.isBumpingToAnotherActor()){
            body.stop();
        }
    }
    public void action_seeItem(){
        this.log.log(Level.INFO, "Action SEE_ITEM --- Running for: " + this.choosenItem.toString());		                
        walkingAttempts=0;
        if(!bot.getMap().safeRunToLocation(choosenItem.location)) {         // unable to reach the choosen item
                log.info("unable to REACH the choosen item");
                previousChoosenItem = choosenItem;
                choosenItem = null;
        }
        this.jumped = false;
    }
    /**
     * runs along healths of strenght at least 8 to recover health
     */
    public void action_medKit(){
        this.log.log(Level.INFO, "Action RUN_MED_KITS");
        bot.getMap().runAroundItemsInTheMap(choosenMedKits, this.useAStar);
    }
    
    public boolean sense_fail() {
        return false;
    }
    
    public boolean sense_succeed() {
        return true;
    }
    
    public boolean sense_seeAnyEnemy(){
        return bot.getMemory().getSeeAnyEnemy();
    }
    /**
     * has better weapon - this magic check goes through weapons in inventory and according to their characteristics
     * decides which is the best - that means which effectiveDistance is lowest and which maximal distance is big enough
     * to reach enemy.
     * </p>
     * <p>
     * Note!: Both effective and maximal distance are guessed and therefore could not work exactly
     * </p>
     */
    public boolean sense_hasBetterWeapon(){
        AgentMemory memory=bot.getMemory();
        if (memory.getAgentLocation() == null || memory.getSeeEnemy() == null || memory.getSeeEnemy().location == null)
            return false;
        AddWeapon weapon = memory.getBetterWeapon(memory.getAgentLocation(), memory.getSeeEnemy().location);
        // platformLog.info("Better weapon : " + weapon + "\nWeapons: " + this.memory.getAllWeapons().toString());                        
        if (weapon == null)
            return false;
        else
            return true;
    }
    /**
     * Wheter still see the same enemy, otherwise stop shooting
     *<br>if have enemyID - checks whether the same enemy is visible, if not, drop him (and stop shooting)
     *<br>if doesn't have enemyID - pick one of the enemy for pursuing
     * @return false if there is no enemy, true, if it is still the same
     */
    public boolean sense_sameEnemy(){
        AgentMemory memory=bot.getMemory();
        AgentBody body=bot.getBody();
        // 1) if have enemyID - checks whether the same enemy is visible, if not, drop ID (and stop shooting)
        if (this.enemy != null){
            this.enemy = memory.getSeePlayer(this.enemy.ID); // refresh information about the enemy,
            // note that even though we've got pointer to the message of the enemy seen, it's still a certain message 
            // from a specific time - when new message arrives it's written as a new message
            if (this.enemy == null){			
                if (memory.isShooting())
                    body.stopShoot(); // stop shooting, we've lost target
                return false;
            }
            // TODO: NEW - FOR TESTING!!!
            if (!memory.getSeeAnyEnemy()) {
                this.lastEnemy = enemy;
                this.enemy = null;
                return false;
            }
        }

        // 2) if doesn't have enemy - pick one of the enemy for pursuing
        if (this.enemy == null){
            this.enemy = memory.getSeeEnemy();
            if (this.enemy == null){
                    body.stop();
                    body.stopShoot();
                    return false;				
            }
        }
        return true;
    }
    public boolean sense_hasAnyLoadedWeapon(){
        return bot.getMemory().hasAnyLoadedWeapon();
    }
    public boolean sense_isShooting(){
        return bot.getMemory().isShooting();
    }
    public boolean sense_isBeingDamaged(){
        return bot.getMemory().isBeingDamaged();
    }
    public boolean sense_pursuedEnemy(){
        return this.lastEnemy!=null;
    }
    public boolean sense_isColliding(){
        return bot.getMemory().isColliding();
    }
    /** 
     * sees reachable item and wants it
     * @return true if there is an item which is useful for agent
     */
    public boolean sense_seeItemAndWantIt(){
        AgentMemory memory=bot.getMemory();
        if (memory.getSeeAnyReachableItem()){
                choosenItem = chooseItem();
                if (choosenItem != null) {
                        this.log.info("NEW ITEM CHOSEN: " + choosenItem);
                        this.log.info("LAST CHOOSEN ITEM: " + previousChoosenItem);
                }
        } else {
                choosenItem = null;
        }
        if ((choosenItem != null) && (!choosenItem.equals(previousChoosenItem)))
            //&& (Triple.distanceInSpace(memory.getAgentLocation(), choosenItem.location) > 20))
            return true;
        else
            return false;
        
    }
    public boolean sense_isHurt(){
        return bot.getMemory().getAgentHealth()<healthLevel;
    }
    /**
     * checks whether there are any medkit items around and if there are
     * checks if the agent is not standing on the first one in the choosenMedKits
     * <p>
     * (bot got stucked because nearestHealth returns Healths according to inventory spots
     * not to the current situation, so the bot with low health got stucked on the inventory spot)
     * <p>
     * @return true if bot can run along med kits - initialize them before that
     */
    public boolean sense_canRunAlongMedKit(){
        AgentMemory memory=bot.getMemory();
        if (this.choosenMedKits == null) {
                this.choosenMedKits = bot.getMap().nearestHealth(4, 8);
                return false;
        }
        // no medkits to run to around the agent - restricted AStar - see nearestHealth
        if (choosenMedKits.isEmpty() || choosenMedKits.size() > 2)
                return false;
        // bot is too close to the object - possibly standing at the only one
        if (Triple.distanceInSpace(choosenMedKits.get(0).location, memory.getAgentLocation()) < 40) {
                // there are many - remove the first one - seeItem has highest priority, so bot should
                // pick up the item anyway and otherwise will not get stucked at the inventory spot of 
                // the item
                if (choosenMedKits.size() > 2)
                        choosenMedKits.remove(0);
                else
                        this.choosenItem = null;
                return false;
        }
        return true;
    }
    /**
     * is there any enemy?
     * @return true if enemy is not null
     */
    public boolean sense_enemy(){
        return enemy!=null;
    }
    /**fills itemsToRunAround
     * 
     */
    private void init_items(){
        this.itemsToRunAround = new ArrayList<Item>();
         for ( Item item :  bot.getMemory().getKnownWeapons())
                this.itemsToRunAround.add(item);
         for ( Item item : bot.getMemory().getKnownArmors())
                this.itemsToRunAround.add(item);
         Collections.shuffle(itemsToRunAround);
    }
    
    /** 
     * choose weapon according to the one he is currently holding
     * <ol>
     * <li> has melee and see ranged => pick up ranged
     * <li> has ranged and see melee => pick up melee
     * <li> pick up first weapon he sees
     * </ol>
     * 
     * @return the choosen one weapon
     */
    private Weapon chooseWeapon() {
        AgentMemory memory=bot.getMemory();
        ArrayList<Weapon> weapons = memory.getSeeReachableWeapons();			
        for (Weapon weapon:weapons) {
                // 0) has no weapon in hands
                if (memory.getCurrentWeapon() == null)
                        return weapon;
                // 1) weapon is ranged, bot has melee
                if ((memory.getCurrentWeapon().melee) && !weapon.isMelee() && !memory.hasWeaponOfType(weapon.weaponType)){
                        return weapon;
                }
                // 2) weapon is melee, bot has ranged
                if (!memory.getCurrentWeapon().melee && weapon.isMelee() && !memory.hasWeaponOfType(weapon.weaponType)){
                        return weapon;
                }
        }
        Weapon chosen = memory.getSeeReachableWeapon();
        if (chosen == null) return null;
        if (!memory.hasWeaponOfType(chosen.weaponType)){
                return chosen;
        }
        return null;
    }

    /**
     * Reasoning about what to do with seen item <br>
     * the easiest way of handeling it will be just to take it every time, but what should we do
     * when there are many of items laying in front of agent?
     * <ol>
     * <li> choose weapon - choose the type he is lacking (melee/ranged)
     * <li> choose armor
     * <li> choose health - if the health is bellow normal maximum
     * <li> choose ammo - if it is suitable for possessed weapons
     * <li> ignore the item
     * </ol>
     */
    private Item chooseItem() {
            // 1) choose weapon - choose the type he is lacking (melee/ranged)
        AgentMemory memory=bot.getMemory();
        if (memory.getSeeAnyReachableWeapon())
                return chooseWeapon();
        // 2) choose armor
        if (memory.getSeeAnyReachableArmor())
                return memory.getSeeReachableArmor();
        // 3) choose health - if the health is bellow normal maximum or the item is boostable
        if (memory.getSeeAnyReachableHealth()) {
                Health health = memory.getSeeReachableHealth();
                if (memory.getAgentHealth() < 100)
                        return health;
                if (health.boostable) // if the health item is boostable, grab it anyway:)
                        return health;
        }	
        // 4) choose ammo - if it is suitable for possessed weapons
        if ((memory.getSeeAnyReachableAmmo()) && 
                (memory.isAmmoSuitable(memory.getSeeReachableAmmo())))
                return memory.getSeeReachableAmmo();
        // 5) ignore the item
        return null;
    }
    
}
